#!/usr/bin/env python3
# JS8Spotter Data Siphon, DB creation tool. Visit https://kf7mix.com/js8spotter.html for information
# Creates a blank DB for Siphon to fill
#
# MIT License, Copyright 2025 Joseph D Lyman KF7MIX -- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
# of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software. The Software IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
# WARRANTIES OF MERCHANTABILITY, FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

import sqlite3

conn = sqlite3.connect('siphon.db')
c = conn.cursor()

c.execute("""CREATE TABLE activity (
    id         INTEGER   PRIMARY KEY AUTOINCREMENT,
    node_id INTEGER,
    type       TEXT,
    value      TEXT,
    dial       TEXT,
    snr        TEXT,
    call       TEXT,
    spotdate   TIMESTAMP,
    freq       TEXT,
    offset     TEXT,
    speed      TEXT
)
""")

conn.commit()
conn.close()

